<?php
/*
=====================================================
 File: init.php
=====================================================
*/

if(!defined('DATALIFEENGINE'))
{
  die("Hacking attempt!");
}

	@include ENGINE_DIR.'/data/forum_config.php';
	
	if ($forum_config['version_id'] !== '2.5') {
		die("DLE Forum not installed. Please run <a href='/dle-forum.php'>dle-forum.php</a>");
	}
	
	include_once ENGINE_DIR.'/forum/language/'.$config['langs'].'/forum.lng';
	
	require_once ENGINE_DIR.'/forum/classes/cache.php';
	
	$fcache = new forum_cache;
	
	require_once ENGINE_DIR.'/forum/sources/components/functions.php';
	
	define('UPLOAD_DIR', ROOT_DIR."/uploads/forum/");

// ********************************************************************************
// IF BLOCKED
// ********************************************************************************

	if ($is_logged and $member_id['forum_warn'] >= $forum_config['warn_max'])
	{
		die ("<center><hr><h2>Your account at a forum is blocked</h2><hr></center>");
	}

// ********************************************************************************
// USER UPDATE
// ********************************************************************************

	if ($is_logged and $forum_config['set_post_num_day'] and !$_SESSION['forum_update'])
	{
		if (!$member_id['forum_update'])
		{
			$db->query("UPDATE " . PREFIX . "_users SET forum_update = '".time()."' WHERE user_id = {$member_id['user_id']}");
		}
		
		$up_days = ($forum_config['set_post_num_day'] * 8640);
		
		if ((time() + $up_days) > $member_id['forum_update'])
		{
			if ($forum_config['set_topic_post'])
			{
				$topic = $db->super_query("SELECT COUNT(tid) as count FROM " . PREFIX . "_forum_topics WHERE author_topic = '$member_id[name]'");
				
				$topic_num = $topic['count'];
			}
			
			$post = $db->super_query("SELECT COUNT(pid) as count FROM " . PREFIX . "_forum_posts
                                                                 WHERE post_author = '$member_id[name]' and is_count");
			
			$post_num = $post['count'];
			
			$update = $forum_config['set_topic_post'] ? ($topic_num + $post_num) : $post_num;
			
			$db->query("UPDATE " . PREFIX . "_users SET forum_post = '$update' WHERE name = '$member_id[name]'");
			
			$db->query("UPDATE " . PREFIX . "_users SET forum_update = '".time()."' WHERE user_id = {$member_id['user_id']}");
			
			$_SESSION['forum_update'] = "1";
		}
	}
    
// ********************************************************************************
// SET MOD REWRITE
// ********************************************************************************
	if (!defined('FORUM_SUB_DOMAIN'))
	{
		if ($forum_config['mod_rewrite'])
		{
			$forum_url = $config['http_home_url']."forum";
		}
		
		else 
		{
			$forum_url = $config['http_home_url']."index.php?do=forum&";
		}
		
		$a_forum_url = $config['http_home_url']."index.php?do=forum&";
	}
	
	else
	{
		if ($forum_config['mod_rewrite'])
		{
			$forum_url = $forum_config['forum_url'];
		}
		
		else
		{
			$forum_url = $forum_config['forum_url']."/index.php?";
		}
		
		$a_forum_url = $forum_config['forum_url']."/index.php?";
	}
	
    $forum_link_array = array();
    
	if ($forum_config['mod_rewrite'])
	{
		$forum_link_array['search'] = $forum_url."/search/";
		
		$forum_link_array['getnew'] = $forum_url."/getnew/";
		
		$forum_link_array['subscription'] = $forum_url."/subscription/";
		
		$forum_link_array['textversion'] = $forum_url."/textversion.html";
		
		function link_category($id, $name)
		{
			global $forum_url;
			
			return ("<a href='{$forum_url}/category_{$id}'>{$name}</a>");
		}
		
		function link_forum($id, $name, $symbol=false)
		{
			global $forum_url;
			
			$name = stripslashes($name);
			
			return ($symbol."<a href='{$forum_url}/forum_{$id}'>{$name}</a>");
		}
		
		function link_topic($id, $name, $title = false)
		{
			global $forum_url;
			
			if ($title) $title = " title='$title'";
			
			return ("<a href='{$forum_url}/topic_{$id}'{$title}>{$name}</a>");
		}
		
		function link_user($user, $title = false)
		{
			global $config;
			
			if (!$title) $title = $user;
			
			return("<a href='{$config['http_home_url']}user/".urlencode($user)."/'>{$title}</a>");
		}
		
		function link_warn($user, $title = false)
		{
			global $forum_url;
			
			if (!$title) $title = $user;
			
			return("<a href='{$forum_url}/warn/".urlencode($user)."/'>{$title}</a>");
		}
		
		function link_rep($user, $title = false)
		{
			global $forum_url;
			
			if (!$title) $title = "0";
			
			return("<a href='{$forum_url}/reputation/".urlencode($user)."/'>{$title}</a>");
		}
	}
	
	else
	{
		$forum_link_array['search'] = $forum_url."act=search";
		
		$forum_link_array['getnew'] = $forum_url."act=getnew";
		
		$forum_link_array['subscription'] = $forum_url."act=subscription";
		
		$forum_link_array['textversion'] = $config['http_home_url']."engine/forum/textversion.php";
		
		function link_category($id, $name)
		{
			global $forum_url;
			
			return ("<a href='{$forum_url}category={$id}'>{$name}</a>");
		}
		
		function link_forum($id, $name, $symbol=false)
		{
			global $forum_url;
			
			$name = stripslashes($name);
			
			return ($symbol."<a href='{$forum_url}showforum={$id}'>{$name}</a>");
		}
		
		function link_topic($id, $name, $title = false)
		{
			global $forum_url;
			
			if ($title) $title = " title='$title'";
			
			return ("<a href='{$forum_url}showtopic={$id}'{$title}>{$name}</a>");
		}
		
		function link_user($user, $title = false)
		{
			global $config;
			
			if (!$title) $title = $user;
			
			return("<a href='{$config['http_home_url']}?subaction=userinfo&user=".urlencode($user)."'>{$title}</a>");
		}
		
		function link_warn($user, $title = false)
		{
			global $forum_url;
			
			if (!$title) $title = $user;
			
			return("<a href='{$forum_url}act=warn&user=".urlencode($user)."'>{$title}</a>");
		}
		
		function link_rep($user, $title = false)
		{
			global $forum_url;
			
			if (!$title) $title = "0";
			
			return("<a href='{$forum_url}act=reputation&user=".urlencode($user)."'>{$title}</a>");
		}
	}

	$tpl_dir = 'forum/';
	
	$metatags['title'] = $forum_config['forum_title']." (Powered By DLE Forum)";
	
	$start_id = $fcache->get('start_id');
	
	if (!$start_id)
	{
		$row_start = $db->super_query("SELECT sid FROM " . PREFIX . "_forum_category ORDER BY posi LIMIT 1");
		
		$start_id = $row_start['sid'];
		
		$fcache->set('start_id', $start_id);
	}
	
	$cats_array = $fcache->get('cats_array');
	
	if (!$cats_array)
	{
		$cats_array = array();
		
		$result = $db->query("SELECT sid, cat_name FROM ". PREFIX ."_forum_category ORDER by posi");
		
		while ($row = $db->get_row($result))
		{
			$cats_array[$row['sid']] = array ();
			
			foreach ($row as $key => $value)
			{
				$cats_array[$row['sid']][$key] = $value;
			}
		}
		
		if (!$cats_array) $cats_array = 'empty';
		
		$fcache->set('cats_array', $cats_array);
	}
	
	$forums_array = $fcache->get('forums_array');
	
	if (!$forums_array)
	{
		$forums_array = array();
		
		$result = $db->query("SELECT id, parentid, main_id, name, access_read, access_write, access_topic, access_mod, access_upload, access_download, password, moderators, postcount, fixpost, banner, q_reply, i_edit FROM ". PREFIX ."_forum_forums ORDER by position");
		
		while ($row = $db->get_row($result))
		{
			$forums_array[$row['id']] = array ();
			
			foreach ($row as $key => $value)
			{
				$forums_array[$row['id']][$key] = $value;
			}
		}
		
		$fcache->set('forums_array', $forums_array);
	}
	
	$sub_forums_array = $fcache->get('sub_forums_array');
	
	if (!$sub_forums_array)
	{
		$sub_forums_array = array();
		
		$result = $db->query("SELECT id, parentid, name FROM ". PREFIX ."_forum_forums WHERE parentid ORDER by position");
		
		while ($row = $db->get_row($result))
		{
			$sub_forums_array[$row['id']] = array ();
			
			foreach ($row as $key => $value)
			{
				$sub_forums_array[$row['id']][$key] = $value;
			}
		}
		
		if (!$sub_forums_array) $sub_forums_array = 'empty';
		
		$fcache->set('sub_forums_array', $sub_forums_array);
	}
	
	$sub_parentid = $fcache->get('sub_parentid');
	
	if (!$sub_parentid)
	{
		$sub_parentid = array();
		
		$result = $db->query("SELECT parentid FROM ". PREFIX ."_forum_forums WHERE parentid ORDER by position");
		
		while ($row = $db->get_row($result))
		{
			$sub_parentid[$row['parentid']] = array ();
			
			foreach ($row as $key => $value)
			{
				$sub_parentid[$row['parentid']][$key] = $value;
			}
		}
		
		if (!$sub_parentid) $sub_parentid = 'empty';
		
		$fcache->set('sub_parentid', $sub_parentid);
	}
	
	$forum_groups = $fcache->get('forum_groups');
	
	if (!$forum_groups)
	{
		$get_forum_groups = $db->query("SELECT * FROM " . PREFIX . "_forum_groups ORDER BY group_id ASC");
		
		$forum_groups = array();
		
		while ($row = $db->get_row($get_forum_groups))
		{
			$forum_groups[$row['group_id']] = array ();
			
			foreach ($row as $key => $value)
			{
				$forum_groups[$row['group_id']][$key] = $value;
			}
		}
		
		$fcache->set('forum_groups', $forum_groups);
	}
	
	$forum_moderators = $fcache->get('forum_moderators');
	
	if (!$forum_moderators)
	{
		$get_moderators = $db->query("SELECT * FROM " . PREFIX . "_forum_moderators ORDER BY mid ASC");
		
		$forum_moderators = array();
		
		while ($row = $db->get_row($get_moderators))
		{
			$forum_moderators[$row['mid']] = array();
			
			foreach ($row as $key => $value)
			{
				$forum_moderators[$row['mid']][$key] = $value;
			}
		}
		
		$fcache->set('forum_moderators', $forum_moderators);
	}
	
	$rank_array = $fcache->get('rank_array');
	
	if (!$rank_array)
	{
		$rank_array = array();
		
		$result = $db->query("SELECT * FROM " . PREFIX . "_forum_titles");
		
		while ($row = $db->get_row($result))
		{
			$rank_array[$row['id']] = array ();
			
			foreach ($row as $key => $value)
			{
				$rank_array[$row['id']][$key] = $value;
			}
		}
		
		if (!$rank_array) $rank_array = 'empty';
		
		$fcache->set('rank_array', $rank_array);
	}
	
	$date_cron = $fcache->get('date_cron');
    
	if (!$date_cron OR $date_cron != date('d'))
	{
		$lim_time = (time() - 86400);
		
		$result = $db->query("SELECT * FROM " . PREFIX . "_forum_files WHERE file_date < '$lim_time' AND file_attach = 0");
		
		while ($row = $db->get_row($result))
		{
			if ($row['file_type'] == "file")
			{
				unlink(UPLOAD_DIR."files/".$row['onserver']);
			}
			
			elseif ($row['file_type'] == "thumb")
			{
				unlink(UPLOAD_DIR."thumbs/".$row['onserver']);
				
				unlink(UPLOAD_DIR."images/".$row['onserver']);
			}
			
			else
			{
				unlink(UPLOAD_DIR."images/".$row['onserver']);
			}
			
			$db->query("DELETE FROM " . PREFIX . "_forum_files WHERE file_id = {$row['file_id']}");
		}
		
		$fcache->set('date_cron', date('d'));
	}

// ********************************************************************************
// MAX ONLINE STATS
// ********************************************************************************
	$max_online = $fcache->get('online');
	
	$forum_config['_max_online_'] = $max_online['count'];

// ********************************************************************************
// IF OFFLINE
// ********************************************************************************
	if ($forum_config['offline'] AND !$forum_groups[$member_id['user_group']]['offline'] AND !$ajax_start)
	{
		die ("<center><hr><h2>DLE Forum - offline</h2><hr></center>");
	}

// ********************************************************************************
// REQUREST
// ********************************************************************************
	if ($_REQUEST['category'])
	{
		$act = 'category';
		
		$cid = intval($_REQUEST['category']);
		
		$t_act = '?c' . $cid;
	}
	
	if ($_REQUEST['showforum'])
	{
		$act = 'forum';
		
		$fid = intval($_REQUEST['showforum']);
		
		$t_act = '?f' . $fid;
	}
	
	if ($_REQUEST['showtopic'])
	{
		$act = 'topic';
		
		$tid = intval($_REQUEST['showtopic']);
		
		$t_act = '?t' . $tid;
	}
	
	if ($forum_config['sessions_log'] AND $act != 'forum' AND $act != 'topic' AND !$not_forum_sessions AND !$ajax_start)
	{
		forum_sessions();
	}

// ********************************************************************************
// TIME
// ********************************************************************************
	$topic_a_time = time() - ($forum_config['topic_new_day'] * 86400);

	if ($is_logged)
	{
		if (!$_SESSION['forum_last'])
		{
			@session_register('forum_last');
			
			$_SESSION['forum_last'] = $member_id['forum_last'];
			
			if (($member_id['forum_last'] + (3600*4)) < $_TIME)
			{
				$db->query("UPDATE LOW_PRIORITY " . USERPREFIX . "_users SET forum_last='{$_TIME}' where user_id={$member_id['user_id']}");
			}
		}
		
		$lasttime = $_SESSION['forum_last'];
	}
	
	else
	{
		if (!$_COOKIE['forum_last'])
		{
			set_cookie ('forum_last', $_TIME, 365);
			
			$_COOKIE['forum_last'] = $_TIME;
		}
		
		if (!$_SESSION['guest_forum_last'])
		{
			@session_register('guest_forum_last');
			
			$_SESSION['guest_forum_last'] = $_COOKIE['forum_last'];
			
			if (($_COOKIE['forum_last'] + (3600*4)) < $_TIME)
			{
				set_cookie ('forum_last', $_TIME, 365);
			}
		}
		
		$lasttime = $_SESSION['guest_forum_last'];
	}

// ********************************************************************************
// Last Visit
// ********************************************************************************
	if (!$act and $lasttime)
	{
		$dle_forum_last_visit = $f_lang['last_visit'] .'&nbsp;'. show_date ($lasttime);
	}
	else
	{
		$dle_forum_last_visit = "";
	}
    
?>